import QtQuick 2.12
import QtQuick.Window 2.12
import "MedComponents"

Window {
    visible: true
    width: 640
    height: 480
    title: qsTr("Medish Demo")

    Rectangle {
        id: headerBar
        anchors {
            top: parent.top
            left: parent.left; right: parent.right
        }
        height: parent.height * 0.08
        z: 10
        DateTimeLabel { anchors.fill: parent }
    }

    Rectangle {
        id: mainContent
        anchors{ top: headerBar.bottom; bottom: parent.bottom; left: parent.left; right: parent.right }
        color: "cyan"
        ListView {
            anchors.fill: parent
            model: dataModel
            spacing: 2
            delegate: ListDelegate {
                height: mainContent.height * 0.1
            }
        }
    }
}
